#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "CircleLineIntersect",
	            Category = "Value",
	            Help = "Finite line, circle intersection",
	            Tags = "circle, line, intersection")]
	#endregion PluginInfo
	public class ValueCircleLineIntersectNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("CircleCenter")]
		ISpread<Vector2D> center;
		
		[Input("CircleRadius", DefaultValue = 1.0)]
		ISpread<double> cr;

		[Input("Line1")]
		ISpread<Vector2D> L1;
		
		[Input("Line2")]
		ISpread<Vector2D> L2;
		
		[Output("Intersection 1 ")]
		ISpread<Vector2D> FIntersection1;
		
		[Output("Intersection 2 ")]
		ISpread<Vector2D> FIntersection2;
		
		[Output("Number of Solutions")]
		ISpread<int> FSolutionCount;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins
 
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FIntersection1.SliceCount = SpreadMax;
			FIntersection2.SliceCount = SpreadMax;
			FSolutionCount.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++)
				{
				Vector2D s1;
				Vector2D s2;
				
				FSolutionCount[i] = CircleLineIntersection(center[i], cr[i], L1[i], L2[i] , out s1, out s2);
				FIntersection1[i] = s1;
				FIntersection2[i] = s2;
			}
				
			
		}
		private int CircleLineIntersection (Vector2D center, double cr, Vector2D L1 , Vector2D L2,  out Vector2D p1, out Vector2D p2)
		{
			p1 = new Vector2D();
			p2 = new Vector2D();
		
		double dx = L2.x - L1.x;
		double dy = L2.y - L1.y;
		double a = dx * dx + dy * dy;
		double b = 2 * (dx * (L1.x - center.x) + dy * (L1.y - center.y));
		double c = L1.x * L1.x + L1.y * L1.y + center.x * center.x + center.y * center.y - 2 * (center.x * L1.x + center.y * L1.y)-(cr * cr);
        double bb4ac = b * b - 4 * a * c;
        
        double mu1 = (-b + Math.Sqrt(bb4ac)) / (2*a);
        double mu2 = (-b - Math.Sqrt(bb4ac)) / (2*a);
        
        double i1x = L1.x + mu1*(dx);
        double i1y = L1.y + mu1*(dy);
   
        double i2x = L1.x + mu2*(dx);
        double i2y = L1.y + mu2*(dy);
      
        double dist1 = Math.Sqrt((center.x-L1.x)*(center.x-L1.x)+(center.y-L1.y)*(center.y-L1.y));
        double dist2 = Math.Sqrt((center.x-L2.x)*(center.x-L2.x)+(center.y-L2.y)*(center.y-L2.y));
       
        
        if  ((bb4ac < 0))   // Not intersecting  (bb4ac < 0)
        {
            return 0;
            }
            
        if (i1x < L1.x & i2x < L1.x & i1x < L2.x & i2x < L2.x | 
            i1y < L1.y & i2y < L1.y & i1y < L2.y & i2y < L2.y | 
            i1x > L1.x & i2x > L1.x & i1x > L2.x & i2x > L2.x | 
            i1y > L1.y & i2y > L1.y & i1y > L2.y & i2y > L2.y)  // No intersecting, line outside the circle
        {
            return 0;
            }
        
        if  ((bb4ac==0) & dist1<cr & dist2<cr) //1 solution tangent  (bb4ac == 0)
        { 
            p1.x = i1x;
            p1.y = i1y;
            return 1;
            }
       
        if  (bb4ac>0 & (dist1>=cr & dist2>=cr))    //2 solutions  Line crossing the circle
        {
            p1.x = i1x;
            p1.y = i1y;
            p2.x = i2x;
			p2.y = i2y;
			return 2;
            }
            
        if  ( (dist1>=cr & dist2<=cr))    //1 solution  One Point in the circle
        {
            p1.x = i2x;
            p1.y = i2y;
  			return 1;
            }
        
        if  ( (dist1<=cr & dist2>=cr))    //1 solution   One Point in the circle
        {
            p1.x = i1x;
            p1.y = i1y;
			return 1;
            }
           
            {
			return 0;    
} 
}
}}

